<?php
/**
 * Latin American Spanish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  Eduardo Cociña
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @author Eduardo Cociña
 * @version $Id: configure_help.es-ar.php 1777 2007-09-30 20:43:59Z fisharebest $
 */

if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "Usted no puede acceder a este archivo de idioma directamente.";
	exit;
}

//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"]	= "Configurar PhpGedView";
$pgv_lang["gedconf_head"]		= "Configuración GEDCOM";
$pgv_lang["configure_head"]		= "Configuración PhpGedView";
$pgv_lang["advanced_conf"]		= "Opciones de configuración Avanzada";
$pgv_lang["standard_conf"]		= "Opciones de configuración Standard";
$pgv_lang["default_user"]	= "Crear el Usuario de Administración por omisión.";
$pgv_lang["about_user"]	= "Primero debe crear el usuario de administración principal. Este usuario tendrá privilegios para actualizar los archivos de configuración, ver datos privados, y crear otros usuarios.";
$pgv_lang["can_admin"]			= "El usuario puede administrar";
$pgv_lang["can_edit"]	= "Usuario puede Editar";
$pgv_lang["can_accept"]			= "Usuario puede Aceptar";
$pgv_lang["add_user"]	= "Añadir Nuevo Usuario";
$pgv_lang["current_users"]	= "Lista actual de Usuarios";
$pgv_lang["leave_blank"]	= "Deje la contraseña en blanco si quiere conservar la contraseña actual.";
$pgv_lang["other_theme"]	= "Otro, escriba por favor";
$pgv_lang["performing_update"]	= "Actualizando.";
$pgv_lang["config_file_read"]	= "Archivo de configuración leído.";
$pgv_lang["does_not_exist"]	= "no existe";
$pgv_lang["media_drive_letter"]	= "La ruta a los archivos de Medios no debe contener una letra de disco; los Medios pueden no mostrarse.";
$pgv_lang["config_write_error"]		= "Error al grabar el archivo de configuración. Controle los permisos e intente nuevamente,";
$pgv_lang["db_setup_bad"]	= "Su configuración actual de la base de datos es incorrecta. Por favor controle su conexión a la base de datos y configure nuevamente.";
$pgv_lang["bad_host_user_pass"]	= "PhpGedView no pudo establecer la conexión con su base de datos MySQL. Controle el nombre de usuario y la contraseña del 'host' y verifique que sean correctas.";
$pgv_lang["bad_database_name"]	= "PhpGedView realizó una conexión a la base de datos MySQL, pero no pudo utilizar la base de datos con el nombre ingresado. Controle que la base de datos exista y que el usuario utilizado posea los permisos apropiados en esa base de datos.";
$pgv_lang["click_here_to_continue"]	= "Presione aquí para continuar.";
$pgv_lang["config_help"]	= "Ayuda de la Configuración";
$pgv_lang["gedcom_adm_head"]	= "Administración GEDCOM";
$pgv_lang["index"]	= "Archivos Índice";
$pgv_lang["mysql"]	= "MySQL";
$pgv_lang["admin_gedcoms"]	= "Presione aquí para administrar los GEDCOMs";
$pgv_lang["current_gedcoms"]	= "GEDCOMs actuales";
$pgv_lang["ged_download"]	= "Descargar";
$pgv_lang["ged_gedcom"]	= "Archivo GEDCOM";
$pgv_lang["ged_title"]	= "Título del GEDCOM";
$pgv_lang["ged_config"]	= "Archivo de Configuración";
$pgv_lang["show_phpinfo"]	= "Mostrar Página de información PHP";
$pgv_lang["confirm_gedcom_delete"]	= "Seguro desea eliminar este GEDCOM?";
$pgv_lang["disabled"]	= "No habilitado";
$pgv_lang["mailto"]	= "Opción Enviar Correo";
$pgv_lang["messaging"]	= "Mensajería Interna de PhpGedView";
$pgv_lang["messaging2"]	= "Mensajería interna con correo electrónico";
$pgv_lang["messaging3"]	= "PhpGedView envía correo sin almacenamiento";
$pgv_lang["no_messaging"]	= "Sin método de contacto";
$pgv_lang["no_logs"]	= "Deshabilitar ingreso";
$pgv_lang["daily"]	= "Diario";
$pgv_lang["admin_verification_waiting"] = "Cuenta(s) de usuario(s) esperando verificación del Administrador";
$pgv_lang["weekly"]	= "Semanal";
$pgv_lang["monthly"]	= "Mensual";
$pgv_lang["yearly"]	= "Anual";
$pgv_lang["enter_db_pass"]	= "Por seguridad, debe ingresar el Nombre de Usuario y la Contraseña de la Base de datos antes de cambiar los valores de configuración.";
$pgv_lang["config_still_writable"]	= "Su archivo config.php todavía se puede escribir. Por seguridad, si ha finalizado la configuración de su sitio, debería modificar los permisos de escritura de este archivo a sólo-lectura.";
$pgv_lang["PGV_DATABASE"] = "Sistema de Archivo en PhpGedView";
$pgv_lang["PGV_DATABASE_help"] = "Indica a PhpGedView qué el tipo de almacenamiento de datos quiere utilizar al importar un archivo GEDCOM al sistema.<br>Seleccione \"Índices\" para utilizar archivos índice almacenados en el directorio index, o seleccione \"MySQL\" para utilizar una base de datos MySQL.<br>Modifica la variable \$PGV_DATABASE en el archivo config.php.";
$pgv_lang["DBHOST"] = "Servidor MySQL";
$pgv_lang["DBHOST_help"] = "El URL o dirección IP del servidor de su base de datos MySQL.<br>Modifica la variable \$DBHOST en el archivo config.php.";
$pgv_lang["DBUSER"] = "Nombre de usuario MySQL";
$pgv_lang["DBUSER_help"] = "Se requiere el Nombre de Usuario de la base de datos MySQL actual para conectarse con ella.<br>Modifica la variable \$DBUSER en el archivo config.php.";
$pgv_lang["DBPASS"] = "Contraseña de la base de datos MySQL";
$pgv_lang["DBPASS_help"] = "La contraseña de la base de datos MySQL para el usuario que ha ingresado en el campo de Nombre de Usuario MySQL.<br>Modifica la variable \$DBPASS en el archivo config.php.";
$pgv_lang["DBNAME"] = "Nombre de la Base de Datos";
$pgv_lang["DBNAME_help"] = "La Base de Datos en el servidor MySQL que desea que PhpGedView utilice. El Nombre de Usuario que escribió en el campo de Nombre de Usuario debe tener privilegios para poder crear, insertar, actualizar, borrar, y seleccionar en esta base de datos.<br>Modifica la variable \$DBNAME en el archivo config.php.";
$pgv_lang["TBLPREFIX"] = "Prefijo de las Tablas de la Base de Datos";
$pgv_lang["TBLPREFIX_help"] = "Un prefijo para añadir a los nombres de las tablas MySQL creadas por PhpGedView. Cambiando este valor puede gestionar múltiples sitios PhpGedView y utilizar la misma base de datos pero con diferentes tablas.<br>Modifica la variable \$TBLPREFIX en el archivo config.php.";
$pgv_lang["last_login"]			= "Último ingreso";
$pgv_lang["date_registered"]	= "Fecha de Registración";
$pgv_lang["privileges"]			= "Privilegios";
$pgv_lang["DEFAULT_GEDCOM"] = "GEDCOM por omisión:";
$pgv_lang["ALLOW_CHANGE_GEDCOM"] = "Permitir a los visitantes elegir distintos GEDCOMs";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"] = "Fijando este valor en <b>Sí</b>, otorga a los visitantes de su sitio <b>y</b> a los usuarios, la opción de elegir el GEDCOM, si tiene múltiples GEDCOMs habilitados en su sitio.<br><br />Si está fijado en <b>No</b> tanto los visitantes <b>como</b> los usuarios registrados, no podrán cambiar el GEDCOM.<br /><br />Modifica la variable \$ALLOW_CHANGE_GEDCOM en el archivo config.php.";
$pgv_lang["GEDCOM"] = "Ruta y nombre del GEDCOM";
$pgv_lang["gedcom_path_help"] = "Primero grabe su archivo GEDCOM en una localización accesible por PHP en su servidor. Luego escriba la ruta y el nombre del archivo, como: <b>./index/nombre.ged</b>.<br /><br>Modifica la variable \$GEDCOM en el archivo config.php.<br><br>Para más ayuda ver el archivo <a href=\"readme.txt\">Readme.txt</a>.";
$pgv_lang["CHARACTER_SET"] = "Codificación del Juego de caracteres";
$pgv_lang["CHARACTER_SET_help"] = "Este es el juego de caracteres de su archivo GEDCOM. Por omisión está seleccionado UTF-8 y debería funcionar bien con casi todos los sitios. Si exporta su GEDCOM usando codificación IBM Windows, debería ingresar WINDOWS aquí.<br><br>Modifica la variable \$CHARACTER_SET en el archivo config.php.<br><br>NOTA: PHP <b>no</b> soporta UNICODE (UTF-16) así que no lo intente y se queje a el equipo PHP :-)";
$pgv_lang["LANGUAGE"] = "Idioma";
$pgv_lang["LANGUAGE_help"] = "Asigna el idioma por omisión del sitio. Los usuarios tienen la posibilidad de modificar este parámetro, utilizando las preferencias de su navegador o seleccionandolo en el encabezamiento de la página, si la variable \$ENABLE_MULTI_LANGUAGE está prefijada como verdadera.<br><br>Modifica la variable \$LANGUAGE en el archivo config.php.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"] = "Permitir a los usuarios elegir el idioma";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "Fijado en \"Sí\" otorga a los usuarios la opción de seleccionar un idioma diferente al definido por omisión, desde una lista desplegable al pié de la página, y diferente también al de su navegador.<br><br>Modifica la variable \$ENABLE_MULTI_LANGUAGE en el archivo config.php.";
$pgv_lang["CALENDAR_FORMAT"] = "Formato del Calendario";
$pgv_lang["CALENDAR_FORMAT_help"] = "Le permite especificar qué tipo de calendario quiere utilizar con este archivo GEDCOM.<br />El Hebreo es el mismo que el calendario Judío, utilizando caracteres Hebreos.<br /><br />Nota: Los valores de las fechas Judías/Hebreas usadas, se calculan a partir de las fechas del calendario Gregoriano/Juliano. Dado que en el calendario Judío el día comienza al crepúsculo, cualquier evento que tenga lugar desde el crepúsculo hasta la medianoche, aparecerá el día anterior a la fecha Judía correcta. La visualización del Hebreo puede ser problemática en los navegadores antiguos. Algunos navegadores antiguos, mostrarán al Hebreo invertido, o directamente no lo mostrarán. <br><br>Modifica la variable \$CALENDAR_FORMAT en el archivo config.php.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"] = "Mostrar Miles Hebreos";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"] = "Muestra Alafim en los calendarios Hebreos. Fijando este parámetro en <b>Sí</b> mostrará el año 1969 como <span lang=\"he-IL\" dir='rtl'>&#1492;' &#1514;&#1513;&#1499;\"&#1496;</span>&lrm; mientras que fijándolo en <b>No</b> mostrará el año como <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;\"&#1496;</span>&lrm;. No tiene impacto en la definición de los años Judíos. El año se mostrará como 5729 independientemente de este parámetro<br />Nota: Esta definición es similar a la constante de calendario CAL_JEWISH_ADD_ALAFIM en PHP 5.0.<br><br>Modifica la variable \$DISPLAY_JEWISH_THOUSANDS en el archivo config.php.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]	= "Mostrar Gershayim Hebreo";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "Muestra comillas simples y dobles al mostrar fechas en Hebreo. Fijando este valor en <b>Sí</b> mostrará el 8 de Febrero de 1969 como <span lang='he-IL' dir='rtl'>&#1499;' &#1513;&#1489;&#1496; &#1514;&#1513;&#1499;\"&#1496;</span>&lrm; mientras que fijándolo en <b>No</b> la mostrará como <span lang='he-IL' dir='rtl'>&#1499; &#1513;&#1489;&#1496; &#1514;&#1513;&#1499;&#1496;</span>&lrm;. Esto no tiene impacto en el año Judío ya que las comillas no se utilizan en las fechas Judías mostradas con caracteres Latinos.<br /><br />Nota: Esta definición es similar a las constantes de calendario CAL_JEWISH_ADD_ALAFIM_GERESH y CAL_JEWISH_ADD_GERESHAYIM en PHP 5.0. Esta definición única, afecta a ambas.<br>Modifica la variable \$DISPLAY_JEWISH_GERESHAYIM en el archivo config.php.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"] = "Pronunciación Ashkenazi Judía";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "Utiliza pronunciaciones Ashkenazi Judías.<br>Fijado en Sí, los meses de Cheshvan y Teves serán tratados con la pronunciación Ashkenazi. Fijado en No cambiará los meses a Hesvan y Tevet.<br>Afecta sólo la configuración Judía. Usando la configuración Hebrea, usará el alfabeto Hebreo.<br>Modifica la variable \$JEWISH_ASHKENAZ_PRONUNCIATION en el archivo config.php.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"] = "Cantidad de Generaciones de Antepasados";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"] = "Define la cantidad de generaciones que se mostrarán por omisión en el Gráfico de Antepasados.<br><br>Modifica la variable \$DEFAULT_PEDIGREE_GENERATIONS en el archivo config.php.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"] = "Máxima cantidad de Generaciones en Antepasados";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"] = "Fija la cantidad máxima de generaciones que se mostrarán en los Gráficos de Antepasados.<br><br>Modifica la variable \$MAX_PEDIGREE_GENERATIONS en el archivo config.php.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"] = "Máxima cantidad de Generaciones en Descendientes";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"] = "Fija la cantidad máxima de generaciones que se mostrarán en los Gráficos de Descendientes.<br><br>Modifica la variable \$MAX_DESCENDANCY_GENERATIONS en el archivo config.php.";
$pgv_lang["USE_RIN"] = "Utilizar el número RIN en lugar del ID del GEDCOM";
$pgv_lang["USE_RIN_help"] = "Si elige \"Sí\" utilizará el número RIN en lugar del ID del GEDCOM cuando lo pida para las ID de las Personas en el archivo de configuración, gráficos y preferencias de usuario. Es útil para programas de genealogía que no exportan GEDCOMs con ID simultáneas de personas, pero siempre utilizan el mismo RIN.<br><br>Modifica la variable \$USE_RIN en el archivo config.php.";
$pgv_lang["PEDIGREE_ROOT_ID"] = "Persona inicial en Gráficos de Antepasados y Descendientes";
$pgv_lang["PEDIGREE_ROOT_ID_help"] = "Define el ID de la persona inicial por omisión, que se mostrará en los Gráficos de Antepasados y Descendientes.<br><br>Modifica la variable \$PEDIGREE_ROOT_ID en el archivo config.php.";
$pgv_lang["GEDCOM_ID_PREFIX"] = "Prefijo ID del GEDCOM";
$pgv_lang["GEDCOM_ID_PREFIX_help"] = "Cuando a los usuarios les sea requerido el ingreso de un prefijo, en los gráficos de antepasados, descendientes, parentesco y otros gráficos, si no lo hacen, por omisión se agregará este prefijo.<br><br>Fija la variable \$GEDCOM_ID_PREFIX en el archivo config.php.";
$pgv_lang["PEDIGREE_FULL_DETAILS"] = "Mostrar detalles de nacimiento y defunción en los Gráficos de Antepasados y Descendientes";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] = "Indica si debe mostrar o no por omisión, los detalles de nacimiento y defunción de una persona.<br><br>Modifica la variable \$PEDIGREE_FULL_DETAILS en el archivo config.php.";
$pgv_lang["PEDIGREE_LAYOUT"] = "Disposición por omisión del Gráfico de Antepasados";
$pgv_lang["PEDIGREE_LAYOUT_help"] = "Indica si el gráfico de antepasados debe ser generado en forma apaisada o vertical.<br><br>Modifica la variable \$PEDIGREE_LAYOUT en el archivo config.php.";
$pgv_lang["SHOW_EMPTY_BOXES"] = "Mostrar cajas vacías en Antepasados";
$pgv_lang["SHOW_EMPTY_BOXES_help"] = "Indica si mostrar o no las cajas vacías en los Gráficos de Antepasados.<br><br>Configura la variable \$SHOW_EMPTY_BOXES en el archivo config.php.";
$pgv_lang["ZOOM_BOXES"] = "Cajas agrandar/achicar en los gráficos";
$pgv_lang["ZOOM_BOXES_help"] = "Permite al usuario utilizar las cajas agrandar/achicar en los gráficos obteniendo así más información. Seleccione \"Desactivada\" para desactivar esta característica. Seleccione \"MouseOver\" para activar la característica al paso del cursor sobre el icono. Presione \"Click\" para activar la característica cuando el usuario presiona sobre el icono.<br><br>Configura la variable \$ZOOM_BOXES en el archivo config.php.";
$pgv_lang["LINK_ICONS"] = "Vínculos \"Pop-Up\" en los gráficos.";
$pgv_lang["LINK_ICONS_help"] = "Permite al usuario seleccionar vínculos a otros gráficos y familiares cercanos de la persona. Seleccione \"Desactivada\" para desactivar esta característica. Seleccione \"MouseOver\" para activar la característica al paso del cursor sobre el icono. Seleccione \"Click\" para activar la característica cuando el usuario presiona sobre el icono.<br><br>Configura la variable \$LINK_ICONS en el archivo config.php.";
$pgv_lang["AUTHENTICATION_MODULE"] = "Archivo Módulo de Validación";
$pgv_lang["AUTHENTICATION_MODULE_help"] = "Archivo desde el cual se cargan las funciones de validación. Implementando las funciones en este archivo, los usuarios pueden modificar PhpGedView para utilizar un método diferente de validación de usuarios y guardarlos en una base de datos diferente. Ojalá los usuarios compartan sus módulos de validación con otros usuarios de PhpGedView.<br><br>Modifica la variable \$AUTHENTICATION_MODULE en el archivo config.php.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Seleccione el texto de bienvenida a usuario tipeado abajo";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "Seleccione exhibir un encabezamiento (multilenguaje) para su texto de bienvenida personalizado.<br><br>Si acepta la opción, el testo se verá así:<br><br>#pgv_lang[welcome_text_cust_head]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Encabezamiento standard para el texto de bienvenida";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "Si ha seleccionado un testo de bienvenida personalizado en la opción anterior, puede ingresar el texto aquí.<br>El texto NO será traducido al lenguaje del visitante, pero se exibirá exactamente como lo ha ingresado.<br>Si lo desea, puede utilizar etiquetas HTML en el texto.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Texto de bienvenida personalizado para el modo de autentificación";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "Aquí puede elegir el texto que aparecerá en la ventana de registración cuanto el modo de autentificación está seleccionado.<br>Tambien puede optar por ingresar su propio texto de bienvenida, pero no será traducido al lenguaje de sus usuarios.<br><br>Los testos de bienvenida son:<br><br><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]# :</b><br><br>#pgv_lang[welcome_text_auth_mode_1]#<br><br><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]# :</b><br><br>#pgv_lang[welcome_text_auth_mode_2]#<br><br><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]# :</b><br><br>#pgv_lang[welcome_text_auth_mode_3]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Texto predefinido que establece que sólo los miembros de la familia pueden solicitar una cuenta de usuario";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Texto predefinido que establece que establece si el usuario aplica para obtener una cuenta de usuario";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Texto predefinido que establece que todos los usuarios pueden solicitar una cuenta de usuario";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Testo de Bienvenida en la página de ingreso en modo Verificación";
$pgv_lang["HIDE_LIVE_PEOPLE"] = "Habilitar la Privacidad";
$pgv_lang["HIDE_LIVE_PEOPLE_help"] = "Esta opción activará todos los parámetros de privacidad y ocultará los detalles de las personas vivas. Estas personas se definen como aquellas que no tienen un evento hace más de \$MAX_ALIVE_AGE años, y no tienen hijos nacidos hace más de \$MAX_ALIVE_AGE años (actualmente \$MAX_ALIVE_AGE años).<br><br>Modifica la variable \$HIDE_LIVE_PEOPLE en el archivo config.php.";
$pgv_lang["REQUIRE_AUTHENTICATION"] = "Requiere validación del usuario";
$pgv_lang["REQUIRE_AUTHENTICATION_help"] = "Habilitando esta opción obligará a los usuarios a registrarse antes de poder ver información en el sitio.<br><br>Habilita la variable \$REQUIRE_AUTHENTICATION en el archivo config.php.";
$pgv_lang["CHECK_CHILD_DATES"] = "Comprobar fechas de los hijos";
$pgv_lang["CHECK_CHILD_DATES_help"] = "Comprueba las fechas de los hijos, cuando determina si una persona ya ha fallecido. En sistemas GEDCOMs grandes y anticuados puede demorar la respuesta de su sitio.<br><br>Modifica la variable \$CHECK_CHILD_DATES en el archivo config.php.";
$pgv_lang["MAX_ALIVE_AGE"] = "Edad a la cual presumiblemente una persona ha fallecido";
$pgv_lang["MAX_ALIVE_AGE_help"] = "Edad máxima que una persona pueda tener o edad máxima de sus hijos para determinar si han fallecido o no.<br><br>Modifica la variable \$MAX_ALIVE_AGE en el archivo config.php.";
$pgv_lang["SHOW_GEDCOM_RECORD"] = "Permitir ver los registros originales del GEDCOM a los usuarios";
$pgv_lang["SHOW_GEDCOM_RECORD_help"] = "Seleccionando \"Sí\" aparecerán vínculos en las páginas de personas, fuentes y familias que permitirán a los usuarios abrir una nueva ventana que permitirá visualizar los datos originales del archivo GEDCOM.<br><br>Modifica la variable \$SHOW_GEDCOM_RECORD en el archivo config.php.";
$pgv_lang["ALLOW_EDIT_GEDCOM"] = "Activar Edición en línea";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"] = "Permite la edición en línea; para este GEDCOM, así los usuarios con privilegio de edición podrán modificar el contenido del GEDCOM en línea.<br><br>Modifica la variable \$ALLOW_EDIT_GEDCOM en el archivo config.php.";
$pgv_lang["INDEX_DIRECTORY"] = "Directorio de los archivos de índice";
$pgv_lang["INDEX_DIRECTORY_help"] = "La ruta a un directorio de lectura y escritura, donde PhpGedView guardará los archivos de índices (incluya la \"/\" final).<br>Modifica la variable \$INDEX_DIRECTORY en el archivo config.php.";
$pgv_lang["ALPHA_INDEX_LISTS"] = "Fraccionar las listas largas por la primera letra";
$pgv_lang["ALPHA_INDEX_LISTS_help"] = "Para listas muy largas de personas y familias, seleccione \"Sí\" para fraccionar el listado en páginas ordenadas por la primera letra del apellido.<br><br>Modifica la variable \$ALPHA_INDEX_LISTS en el archivo config.php.";
$pgv_lang["NAME_FROM_GEDCOM"] = "Mostrar el nombre desde el GEDCOM";
$pgv_lang["NAME_FROM_GEDCOM_help"] = "Por omisión PhpGedView utiliza el nombre almacenado en los índices para mostrar el nombre de una persona. Con algunos idiomas y formatos GEDCOM, el nombre clasificable almacenado en los índices no se muestra correctamente y la mejor forma de corregirlo es mostrarlo directamente desde el GEDCOM. Los nombres con apellidos españoles son un buen ejemplo. Un nombre español tendrá la forma Nombre, apellido paterno, apellido materno. Utilizando los índices para ordenar y visualizar, resultaría: Nombre, Apellido de la Madre, Apellido del Padre, lo cual es incorrecto. Tomando el nombre directamente desde el GEDCOM se mostrará correctamente. Sin embargo, recuperar el nombre desde el archivo GEDCOM hará que el programa funcione un poco más lentamente.<br><br>Modifica la variable \$NAME_FROM_GEDCOM en el archivo config.php.";
$pgv_lang["SHOW_ID_NUMBERS"] = "Mostrar los números ID a continuación de los nombres";
$pgv_lang["SHOW_ID_NUMBERS_help"] = "Muestra los números ID entre paréntesis, después del nombre de la persona en los gráficos.<br><br>Modifica la variable \$SHOW_ID_NUMBERS en el archivo config.php.";
$pgv_lang["SHOW_PEDIGREE_PLACES"] = "Número de Lugares en las cajas de la persona";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"] = "Muestra qué nivel de información de Lugares se mostrará en las cajas o gráficos. Ingresando 9 se mostrarán todos los Lugares. Ingresando 0 se ocultarán completamente los Lugares. Ingresando 1 se mostrará el primer nivel, ingresando 2 se mostrarán los 2 primeros niveles, etc.<br><br>Modifica la variable \$SHOW_PEDIGREE_PLACES en el archivo config.php.";
$pgv_lang["MULTI_MEDIA"] = "Permitir características MultiMedio";
$pgv_lang["MULTI_MEDIA_help"] = "GEDCOM 5.5 y posteriores permite almacenar fotos, videos, y otros objetos MultiMedio en su archivo GEDCOM. Si no incluye objetos MultiMedio en su GEDCOM puede desactivar esta característica cambiando el valor a \"No\". <br>Vea la sección MultiMedios en el archivo <a href=\"readme.txt\">readme.txt</a> para mayor información sobre cómo incluir MultiMedios en su sitio.<br><br>Modifica la variable \$MULTI_MEDIA en el archivo config.php.";
$pgv_lang["MEDIA_DIRECTORY"] = "Directorio de archivos MultiMedio";
$pgv_lang["MEDIA_DIRECTORY_help"] = "La ruta a un directorio de lectura donde PhpGedView buscará los archivos MultiMedio. Debe ser relativa dentro del sitio PGV, como ./media/ (incluya la \"/\" final).<br><br>Modifica la variable \$MEDIA_DIRECTORY en el archivo config.php.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"] = "Niveles de directorio de MultiMedios para archivar";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"] = "Un valor 0 ignorará todos los directorios en la ruta de archivo del objeto de MultiMedio. Un valor 1 utilizará el primer directorio conteniendo la imagen. Incrementando el valor numérico se incrementa el número de directorios padre incluidos en la ruta.<br>Por ejemplo, si vincula una imagen en su GEDCOM con una ruta como ésta: C:\\Documents and Settings\\User\\My Documents\\My Pictures\\Genealogy\\Surname Line\\grandpa.jpg , un valor 0 trasladará esta ruta a ./media/grandpa.jpg. Un valor 1 la trasladará a ./media/Surname Line/grandpa.jpg, etc. La mayoría sólo necesitará utilizar 0. Pero es posible que algunos objetos MultiMedio tengan el mismo nombre y por tanto, se sobreescribirían. Esto le permite organizar mejor sus objetos MultiMedio y prevenir catástrofes con los nombres.<br><br>Modifica la variable \$MEDIA_DIRECTORY_LEVELS en el archivo config.php.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"] = "Mostrar miniaturas en las cajas de las personas";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] = "Si ha activado MultiMedios en su sitio, entonces podrá hacer que PhpGedView muestre una imagen en miniatura al lado del nombre de la persona en informes y cajas. Actualmente PhpGedView utiliza como miniatura el primer objeto MultiMedio listado en el registro GEDCOM. Para personas con muchas imágenes, debería ordenar los objetos MultiMedios para que aparezca primero como miniatura el que usted desee.<br>Vea la sección MultiMedios en el archivo <a href=\"readme.txt\">readme.txt</a> para mayor información sobre cómo incluir MultiMedios en su sitio.<br><br>Modifica la variable \$SHOW_HIGHLIGHT_IMAGES en el archivo config.php.";
$pgv_lang["ENABLE_CLIPPINGS_CART"] = "Activar el Carrito Genealógico";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] = "El Carrito Genealógico permite a los visitantes de su sitio añadir la información de personas a un archivo GEDCOM que luego podrán descargar e importar en su propio programa de genealogía.<br><br>Modifica la variable \$ENABLE_CLIPPINGS_CART en el archivo config.php.";
$pgv_lang["HIDE_GEDCOM_ERRORS"] = "Ocultar los errores GEDCOM";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"] = "Seleccionando \"Sí\" ocultará los mensajes de error producidos por PhpGedView cuando no interprete alguna etiqueta GEDCOM en su archivo. PhpGedView hace todo lo posible por cumplir el standard GEDCOM 5.5, pero muchos programas de genealogía incluyen sus etiquetas propias. Vea el archivo <a href=\"readme.txt\">readme.txt</a> para mayor información.<br><br>Modifica la variable \$HIDE_GEDCOM_ERRORS en el archivo config.php.";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "Si desea eliminar un apellido de la lista de Apellidos Comunes sin aumentar el valor del umbral, puede hacerlo ingresando aquí al apellido. Si ingresa más de un apellido, debe separarlos con comas. Los apellidos son sensibles a mayúsculas y minúsculas.";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Nombres a quitar de la lista de Apellidos Comunes (separados por coma)";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "Si la cantidad de veces que un determinado apellido aparece es menor que el umbral. no aparecerá en la lista. Puede agregarse manualmente aquí. Si agrega más de un apellido, estos deben separarse con comas. Los apellidos son sensibles a mayúsculas y minúsculas.";
$pgv_lang["COMMON_NAMES_ADD"]	= "Nombres a agregar a Apellidos Vomunes (separados por comas)";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "Este es la cantidad de veces que debe repetirse un apellido, antes de aparecer en la lista de Apellidos Comunes en la página de Bienvenida.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Mínima cantidad de apellidos antes de aparecer en Apellidos Comunes";
$pgv_lang["WORD_WRAPPED_NOTES"] = "Añadir espacios donde las notas fueron comprimidas";
$pgv_lang["WORD_WRAPPED_NOTES_help"] = "Algunos programas de genealogía compactan las notas en los límites de las palabras mientras que otros lo hacen en cualquier parte. Esto puede producir que PhpGedView escriba las palabras sin espacios entre ellas. Seleccionando \"Sí\" añadirá un espacio entre palabras donde los espacios fueron compactados en el GEDCOM.<br><br>Modifica la variable \$WORD_WRAPPED_NOTES en el archivo config.php.";
$pgv_lang["SHOW_CONTEXT_HELP"]	= "Mostrar Ayuda Contextual <b>?</b> por omisión.";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "Esta opción habilitará signos de interrogación <b>(?)</b> como vínculos de ayuda, próximos a las opciones en las páginas, de forma tal que los visitantes podrán obtener ayuda contextual acerca de las opciones disponibles.<br><br>Modifica la variable \$SHOW_CONTEXT_HELP en el archivo config.php.";
$pgv_lang["HOME_SITE_URL"] = "URL principal del sitio";
$pgv_lang["HOME_SITE_URL_help"] = "Un URL incluido en el encabezamiento suministrado por el Tema que genera un vínculo a su página principal.<br><br>Modifica la variable \$HOME_SITE_URL en el archivo config.php.";
$pgv_lang["HOME_SITE_TEXT"] = "Texto del vínculo a la página principal";
$pgv_lang["HOME_SITE_TEXT_help"] = "El texto usado para generar el vínculo a su página principal.<br><br>Modifica la variable \$HOME_SITE_TEXT en el archivo config.php.";
$pgv_lang["CONTACT_EMAIL"] = "Dirección de correo electrónico del usuario de contacto de genealogía";
$pgv_lang["CONTACT_EMAIL_help"] = "La dirección de Correo Electrónico que los visitantes deberán utilizar para realizar consultas sobre los datos genealógicos del sitio (actualmente \$CONTACT_EMAIL).<br><br>Modifica la variable \$CONTACT_EMAIL en el archivo config.php.";
$pgv_lang["CONTACT_METHOD"]	= "Método de contacto";
$pgv_lang["CONTACT_METHOD_help"] = "El método que los usuarios utilizarán para conectarse con el vínculo \"Comunicarse con el Usuario\" por preguntas de genealogía.<br>La opción \"Correo Electrónico\" agregará un vínculo que el usuario podrá presionar para enviarle correo electrónico.<br>La opción \"Mensajería interna\" utilizará el sistema de mensajes interno de PhpGedView y no se enviarán mensajes por correo electrónico.<br>La opción \"Mensajes con correo electrónico\" es la originalmente seleccionada y utilizará el sistema de interno de mensajes de PhpGedView enviando además copias de los mensajes por correo electrónico.<br>La opción \"Correo Electrónico sin almacenamiento\" permite que PhpGedView administre los mensajes que se enviarán como Correo Electrónico, pero sin almacenar internamente los mensajes. Seleccionando \"Sin Mensajes\" no proporcionará a los visitantes opciones para comunicarse con Ud.<br><br>Modifica la variable \$CONTACT_METHOD en el archivo config.php.";
$pgv_lang["WEBMASTER_EMAIL"] = "Correo electrónico del Administrador Principal";
$pgv_lang["WEBMASTER_EMAIL_help"] = "La dirección de correo electrónico que los visitantes deberían de utilizar para consultas técnicas o errores en su sitio (actualmente \$CONTACT_EMAIL).<br><br>Modifica la variable \$WEBMASTER_EMAIL en el archivo config.php.";
$pgv_lang["SUPPORT_METHOD"] = "Método de soporte";
$pgv_lang["SUPPORT_METHOD_help"] = "El método que las visitas utilizarán para comunicarse con el \"Usuario de soporte\" por consultas de genealogía.<br>La opción \"Correo Electrónico\" agregará un vínculo que el usuario podrá presionar para enviarle correo electrónico usando su propio programa.<br>La opción \"Mensajería interna\" utilizará el sistema de mensajes interno de PhpGedView y no se enviarán mensajes por correo electrónico.<br>La opción \"Mensajes con correo electrónico\" es la originalmente seleccionada y utilizará el sistema de interno de mensajes de PhpGedView enviando además copias de los mensajes por correo electrónico.<br>Seleccionando la opción \"Sin mensajes\" no proporcionará a los visitantes opciones para comunicarse con Ud.<br><br>Modifica la variable \$SUPPORT_METHOD en el archivo config.php.";
$pgv_lang["FAVICON"] = "Icono para Favoritos";
$pgv_lang["FAVICON_help"] = "Indique aquí la ubicación donde se encuentra el icono que quiere que aparezca en el menú Favoritos del navegador del usuario, cuando un visitante agregue el vínculo (marcador) de su sitio.<br><br>Modifica la variable \$FAVICON en el archivo config.php.";
$pgv_lang["THEME_DIR"] = "Directorio de los Temas";
$pgv_lang["THEME_DIR_help"] = "El directorio donde se guardan los archivos de los distintos temas de PhpGedView. Puede adaptar cualquiera de los temas standard que se suministran con PhpGedView para dar a su sitio un estilo único y diferente.<br>Vea la sección del archivo <a href=\"readme.txt\">readme.txt</a> para mayor información.<br><br>Modifica la variable \$THEME_DIR en el archivo config.php.";
$pgv_lang["TIME_LIMIT"] = "Tiempo Límite PHP";
$pgv_lang["TIME_LIMIT_help"] = "El máximo de tiempo en segundos que debería estar permitido procesar a PhpGedView. Originalmente es 1 minuto.<br>Dependiendo del tamaño de su archivo, necesitaría incrementar este tiempo cuando requiera construir los índices. Fije este valor en 0, para permitir que PhpGedView procese ininterrumpidamente.<br><br>PRECAUCIÓN: Fijando el valor en 0 ó demasiado alto podría paralizar algunos sistemas operativos hasta la finalización del proceso. De esta forma podría ocurrir que nunca finalizara hasta que un administrador del sitio interrumpa el proceso o restaure el servidor.<br>Un informe grande de antepasados puede llevar mucho tiempo; definiendo un valor bajo se evita que algún usuario pueda \"congelar\" el servidor por solicitar un informe de antepasados de 1000 generaciones!.";
$pgv_lang["PGV_SESSION_SAVE_PATH"] = "Ruta para Guardar Sesión";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"] = "La ruta para guardar los archivos de sesión de PhpGedView.<br>Algunos servidores no tienen PHP configurado adecuadamente y las sesiones no se mantienen entre solicitudes de página. Permite a los administradores del sitio evitarlo, grabando el archivo en uno de sus directorios locales.<br />Si necesita cambiarlo, el directorio ./index/ es una buena opción. Por omisión el campo estará vacío, que utilizará la ruta configurada en el archivo php.ini.<br>Modifica la variable \$PGV_SESSION_SAVE_PATH en el archivo config.php.";
$pgv_lang["SERVER_URL"] = "URL del servidor";
$pgv_lang["SERVER_URL_help"] = "Si utiliza https o un puerto distinto al de por omisión, necesitará ingresar aquí el URL para acceder a su servidor.<br>Modifica la variable \$SERVER_URL en el archivo config.php.";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "En encabezamientos normales para correos externos, se utilizan la dirrección de correo y el nombre. Algunos sistemas de correo no lo aceptan. Optando por si, sólo se utilizará la dirrección de correo.<br><br>Modifica la variable \$PGV_SIMPLE_MAIL en el archivo config.php.";
$pgv_lang["PGV_SIMPLE_MAIL"] = "Usar encabezamientos simples en los correos externos";
$pgv_lang["PGV_SESSION_TIME"] = "Duración de la Sesión";
$pgv_lang["PGV_SESSION_TIME_help"] = "El tiempo en segundos que la sesión de PhpGedView permanece activa antes de requerir nuevamente la contraseña. Por omisión, es de 2 horas.<br>Modifica la variable \$PGV_SESSION_TIME en el archivo config.php.";
$pgv_lang["SHOW_STATS"] = "Mostrar Estadísticas de Ejecución";
$pgv_lang["SHOW_STATS_help"] = "Muestra el tiempo demorado en la ejecución de la página y las consultas a la base de datos al pié de cada página.<br><br>Modifica la variable \$SHOW_STATS en el archivo config.php.";
$pgv_lang["SHOW_COUNTER"]	= "Mostrar contadores de aciertos";
$pgv_lang["SHOW_COUNTER_help"]	= "Muestra contadores de aciertos en el portal y páginas individuales.<br /><br />Modifica la variable \$SHOW_COUNTER en el archivo config.php.";
$pgv_lang["USE_REGISTRATION_MODULE"] = "Permitir a los usuarios solicitar registración de cuenta";
$pgv_lang["welcome_new_help"]		= "Esta ventana de ayuda le guiará durante el proceso de configuración. A medida que ingrese diferentes campos, esta ventana le suministrará información de ayuda del campo sobre el que se encuentre. Si desea puede cerrar esta ventana; para abrirla nuevamente presione en uno de los signos de interrogación \"?\" próximos al nombre del campo.";
$pgv_lang["welcome_new"]			= "Bienvenido a su nuevo sitio PhpGedView. Dado que está viendo esta página, ha instalado PhpGedView con éxito y puede comenzar a configurarlo en la forma que desee.<br>";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "Permite al usuario seleccionar su propio tema desde un menu descolgable (si está implemetado en el tema)<br>Require qe la variable ALLOW_USER_THEMES esté seleccionada como verdadera.<br>Modifica la variable \$ALLOW_THEME_DROPDOWN en el archivo config.php.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Mostrar el selector de Temas descolgable, para cambiar el Tema.";
$pgv_lang["USE_REGISTRATION_MODULE_help"] = "Proporciona a los usuarios la opción de autorregistrarse en el sitio.<br /><br />El visitante recibirá un correo electrónico con el código para verificar su solicitud.<br />Después de la verificación el administrador deberá aprobar la registración para que sea válida.<br /><br />Activa la variable \$USE_REGISTRATION_MODULE en el archivo config.php.";
$pgv_lang["ALLOW_USER_THEMES"] = "Permitir a los usuarios elegir su propio tema.";
$pgv_lang["ALLOW_USER_THEMES_help"] = "Proporciona a los usuarios la opción de seleccionar su propio tema.<br>Activa la variable \$ALLOW_USER_THEMES en el archivo config.php.";
$pgv_lang["CREATE_GENDEX"] = "Crea archivos GENDEX";
$pgv_lang["CREATE_GENDEX_help"] = "Activa la posibilidad de generar archivos GENDEX cuando se importa un archivo GEDCOM. Los archivos Gendex se almacenan en el directorio <b>./index</b><br><br>Modifica la variable \$CREATE_GENDEX en el archivo config.php.";
$pgv_lang["gedcom_title_help"]	= "Ingrese una frase que describa el contenido de este archivo cuando los visitantes elijan entre los GEDCOMs disponibles en su sitio.";
$pgv_lang["LOGFILE_CREATE"] = "Guardar archivos de registro";
$pgv_lang["LOGFILE_CREATE_help"] = "Frecuencia con la que el programa deberá guardar archivos de registro de las operaciones realizadas.<br /><br />Crea la variable \$LOGFILE_CREATE en el archivo config.php.";
$pgv_lang["PGV_MEMORY_LIMIT"]	= "Límite máximo de memoria.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "La cantidad máxima de memoria utilizable por las funciones de PhpGedView. Por omisión es 16Mb. Muchos 'hosts' deshabilitan esta opción en su configuración PHP; de tal forma, un cambio en este valor puede no afectar el ajuste de memoria máxima.<br /><br />Modifica la variable \$PGV_MEMORY_LIMIT en el archivo config.php.";
$pgv_lang["PGV_STORE_MESSAGES"]	= "Permitir el archivo de mensajes en línea:";
$pgv_lang["PGV_STORE_MESSAGES_help"] = "Especifica si los mensajes enviados por PhpGedView serán archivados en la base de datos. Establecido en Sí, permitirá a los usuarios recuperar sus mensajes cuando ingresen a PGV. Si está establecido en No, sólo se enviarán mensajes por correo electrónico.<br /><br />Modifica la variable \$PGV_STORE_MESSAGES en el archivo config.php.";
$pgv_lang["review_readme"] = "Debería primero leer el archivo <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> antes de continuar la configuración de PhpGedView.<br><br>";
$pgv_lang["return_editconfig"]	= "Puede retornar a esta configuración en cualquier momento dirigiendo su navegador hacia el archivo editconfig.php o presionando el vínculo <b>Configuración</b> en la página de <b>Administración</b>.<br />";
$pgv_lang["return_editconfig_gedcom"]	= "Puede retornar a esta configuración en cualquier momento, presionando el vínculo: <b>Editar</b> en la tabla <b>GEDCOMs actuales</b> de la página de <b>Administración</b> o dirigiendo su navegador hacia el archivo editconfig_gedcom.php.<br />";
$pgv_lang["save_config"] = "Guardar Configuración";
$pgv_lang["reset"] 			= "Reestablecer";
$pgv_lang["download_here"] = "Presione para grabar un archivo.";
$pgv_lang["download_gedconf"] = "Guardar la configuración GEDCOM.";
$pgv_lang["not_writable"] = "Se ha detectado que PHP no puede grabar el archivo de configuración. Podrá utilizar el botón <b>Guardar</b> para grabar su configuración a un archivo que posteriormente pueda cargar manualmente.";
$pgv_lang["download_file"] = "Guardar archivo.";
$pgv_lang["upload_to_index"] = "Cargar archivo a su directorio índice.";
$pgv_lang["edit_privacy"] = "Editar archivo de Privacidad";
$pgv_lang["edit_privacy_title"]	= "Editar las Opciones de Privacidad del GEDCOM";
$pgv_lang["PRIV_PUBLIC"] = "Mostrar al público";
$pgv_lang["PRIV_USER"] = "Mostrar sólo a usuarios registrados";
$pgv_lang["PRIV_NONE"] = "Mostrar sólo a administradores";
$pgv_lang["PRIV_HIDE"] = "Ocultar aún a administradores";
$pgv_lang["save_changed_settings"] = "Guardar cambios";
$pgv_lang["add_new_pp_setting"] = "Agregar una nueva definición para la Privacidad Personal";
$pgv_lang["add_new_up_setting"] = "Agregar una nueva definición para la Privacidad del Usuario";
$pgv_lang["add_new_gf_setting"]	= "Agregar una nueva definición para los Acontecimientos Globales de Privacidad";
$pgv_lang["add_new_pf_setting"] = "Agregar una nueva definición de Acontecimientos de Privacidad Personal";
$pgv_lang["add_new_pf_setting_indi"] = "Agregar una nueva definición para Acontecimientos Personales de Privacidad para Individuos";
$pgv_lang["add_new_pf_setting_source"] = "Agregar una nueva definición para Acontecimientos de Privacidad Personal para Fuentes";
$pgv_lang["privacy_indi_id"]	= "ID - Individuo";
$pgv_lang["privacy_source_id"]	= "ID - fuente";
$pgv_lang["privacy_indi_source"]	= "Individuo / Fuente";
$pgv_lang["privacy_indi"]	= "Individuo";
$pgv_lang["privacy_source"]	= "Fuente";
$pgv_lang["file_read_error"] = "ERROR!!! No pudo leerse el archivo de privacidad";
$pgv_lang["general_settings"] = "Características generales de privacidad";
$pgv_lang["person_privacy_settings"] = "Características de Privacidad Personales";
$pgv_lang["edit_exist_person_privacy_settings"] = "Editar las características de Privacidad Personal existentes";
$pgv_lang["user_privacy_settings"] = "Características de Privacidad del Usuario";
$pgv_lang["edit_exist_user_privacy_settings"] = "Editar las características de Privacidad del Usuario existentes";
$pgv_lang["global_facts_settings"] = "Características de Privacidad de Acontecimientos Globales";
$pgv_lang["edit_exist_global_facts_settings"] = "Editar las características de Privacidad de Acontecimientos Globales existentes";
$pgv_lang["person_facts_settings"] = "Características de Privacidad de Acontecimientos Personales";
$pgv_lang["edit_exist_person_facts_settings"] = "Editar las características de Privacidad de Acontecimientos Personales existentes";
$pgv_lang["general_privacy_help"]	= "Los <b>#pgv_lang[general_settings]#.</b><br />Estas serán las opciones por omisión para este GEDCOM en particular.<br />Controle bajo el título de la página si está editando el GEDCOM correcto.<br /><br />También significa que para cada GEDCOM en su sitio (si tiene más de uno) PhpGedView puede definir distintas opciones.<br /><br />Puede desechar estas opciones generales usando otras Formularios de Privacidad en la página #pgv_lang[edit_privacy_title]#.<br />#pgv_lang[more_config_help]#";
$pgv_lang["accessible_by"] = "Mostrar a";
$pgv_lang["hide"] = "Ocultar";
$pgv_lang["show_question"] = "Mostrar?";
$pgv_lang["user_name"] = "Nombre de usuario";
$pgv_lang["name_of_fact"] = "Nombre del acontecimiento";
$pgv_lang["choice"] = "Elección";
$pgv_lang["fact_show"] = "Mostrar acontecimiento";
$pgv_lang["fact_details"] = "Mostrar los detalles del acontecimiento";
$pgv_lang["privacy_header"] = "Editar características de privacidad";
$pgv_lang["unable_to_find_privacy_indi"] = "No pudo encontrarse a un individuo con ID ";
$pgv_lang["save_and_import"] = "Después de guardar esta configuración GEDCOM deberá importar el GEDCOM seleccionando el botón <b>Importar GEDCOM</b> o seleccionando <b>Administración -> Administración de GEDCOMs -> Importar GEDCOM</b>";
$pgv_lang["SHOW_LIVING_NAMES"] = "Mostrar los nombres de personas vivas";
$pgv_lang["SHOW_RESEARCH_LOG"] = "Mostrar Registro de Investigación";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"] = "Utilizar privacidad de parentesco";
$pgv_lang["MAX_RELATION_PATH_LENGTH"] = "Máxima longitud de la ruta de relación";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"] = "Controlar parentesco por matrimonio";
$pgv_lang["SHOW_DEAD_PEOPLE"] = "Mostrar personas fallecidas";
$pgv_lang["help_info"] = "Puede obtener ayuda para cada ítem presionando el <b>?</b> próximo a la etiqueta de cada celda.";
$pgv_lang["SHOW_LIVING_NAMES_help"] = "Mostrar nombres de personas vivas<br><br>Los nombres de las personas vivas deben mostrarse al público<br><br>Modifica la variable \$SHOW_LIVING_NAMES en el archivo de privacidad seleccionado.";
$pgv_lang["SHOW_RESEARCH_LOG_help"] = "Mostrar el Registro de Investigación<br><br>Qué tipo de usuario puede ver el Registro de Investigación si está instalado.<br><br>Modifica la variable \$SHOW_RESEARCH_LOG en el archivo de privacidad seleccionado.";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"] = "Usar privacidad de parentesco<br><br>Un valor \"No\" significa que los usuarios registrados pueden ver los detalles de todas las personas vivas.<br>Un valor \"Sí\" significa que los usuarios sólo pueden ver los detalles de las personas vivas de las cuales son parientes.<br>Modifica la variable \$USE_RELATIONSHIP_PRIVACY en el archivo de privacidad seleccionado.";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"] = "Máxima longitud de la línea de parentesco<br><br>Modifica la variable \$MAX_RELATION_PATH_LENGTH en el archivo de privacidad seleccionado.<br><br>Si está activada #pgv_lang[USE_RELATIONSHIP_PRIVACY] los usuarios registrados que hayan ingresado, sólo podrán ver y editar individuos comprendidos dentro de este nivel de parentesco.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"] = "Controlar parentesco por matrimonio<br><br>Controla el parentesco político por matrimonio.<br><br>Modifica la variable \$CHECK_MARRIAGE_RELATIONS en el archivo de privacidad seleccionado.";
$pgv_lang["SHOW_DEAD_PEOPLE_help"] = "Mostrar personas fallecidas<br><br>Modifica el nivel de privacidad de acceso para todas las personas fallecidas";
$pgv_lang["find_sourceid"]			= "Encontrar el ID de la Fuente";
$pgv_lang["person_privacy_help"] = "<b>#pgv_lang[person_privacy_settings]#.</b><br />Estas opciones proporcionan a los administradores la posibilidad de desestimar las opciones de privacidad personales por omisión para un individuo en particular de este GEDCOM.<br />Suponga por ejemplo que existe un niño que falleció en su infancia. Normalmente, dado que esta persona ha fallecido, sus datos serían de acceso público a los usuarios. Pero Ud. y el resto de su familia serían aún privados. No desea eliminar los datos del fallecimiento de este niño pero quiere ocultar los detalles y hacerlos privados. Si este niño tiene un ID de I100, debería ingresar los siguientes detalles de privacidad<br><br>ID: I100<br>Mostrar a: \"Mostrar sólo a usuarios registrados\"<br><br>También funciona en la forma opuesta.<br />Si se quisiera hacer público los detalles de una persona (ID 101) que se sabe ha fallecido pero que no se posee información de la fecha de su muerte, se podría agregar lo siguiente:<br><br>ID: I101<br>Mostrar a: \"Mostrar al público\"<br><br>Modifica las variables \$person_privacy en el archivo de privacidad seleccionado.";
$pgv_lang["user_privacy_help"] = "<b>#pgv_lang[user_privacy_settings]#.</b><br />Estas definiciones proporcionan a los administradores la posibilidad de desestimar las opciones por omisión para los individuos en el GEDCOM basados en el Nombre de Usuario.<br><br>De forma tal que si no se desea que el usuario \"Juan\" vea los detalles de un individuo y ese individuo tiene un ID I100 en el GEDCOM, se puede configurar de esta forma:<br><br>Nombre de Usuario: Juan<br>ID: I100<br>Mostrar?: \"Ocultar\"<br><br> y los detalles del individuo no se mostrarán sólo para el usuario \"Juan\".<br><br>Para mostrar los detalles de I101 al usuario \"Juan\" (que normalmente estarían ocultos, porque I101 aún vive) seleccione:<br><br>Nombre de usuario: Juan<br>ID: I100<br>Mostrar?: \"Mostrar\"<br><br>Modifica las variables \$person_privacy en el archivo de privacidad seleccionado.";
$pgv_lang["global_facts_help"] = "<b>#pgv_lang[global_facts_settings]#.</b><br />Definen acontecimientos a un nivel global que deberían estar ocultos para todos los individuos en el GEDCOM.<br><br>El elemento [\"Nombre del acontecimiento\"] determina qué acontecimientos deben aparecer como ocultos. El elemento [\"Opción\"] selecciona el acontecimiento en sí mismo o sus detalles relacionados. El elemento [\"Mostrar a\"] determina a qué nivel de acceso se muestra el acontecimiento.<br><br>La matriz \$global_facts está pensada para ocultar ciertos acontecimientos para todos los individuos vivos o muertos por su etiqueta GEDCOM. Por omisión la etiqueta SSN se oculta al público. Esto es para prevenir el robo de números de seguridad social o realizar robos de identidad de sus parientes fallecidos que probablemente sea más importante en EEUU.<br>Si se desea ocultar todos los matrimonios al público en el GEDCOM, se debería seleccionar:<br><br>Nombre del acontecimiento: (MARR) - Matrimonio<br>Opción: \"Mostrar acontecimientos\"<br>Mostrar a?: \"Mostrar sólo a usuarios registrados\"<br><br>Estas opciones ocultarán los matrimonios (y sus detalles relacionados) a cualquiera que no sea administrador.<br><br>Diferente de todas las otras opciones, en \"acontecimientos globales\" se pueden ocultar acontecimientos aún para administradores. Esto es para suprimir completamente acontecimientos no deseados.<br><br>Modifica las variables \$global_facts en el archivo de privacidad seleccionado.";
$pgv_lang["person_facts_help"] = "<b>#pgv_lang[person_facts_settings]#.</b><br />Definen acontecimientos que están ocultos para una persona en particular en el GEDCOM y el nivel al cual están ocultos.<br><br>El primer elemento es el ID de la persona, el segundo elemento es el acontecimiento.<br><br>El elemento [\"Opción\"] selecciona el acontecimiento propiamente dicho o sus detalles relacionados. El elemento [\"Mostrar a\"] determina a qué nivel se muestra el acontecimiento.<br><br>La matriz \$person_facts funciona del mismo modo que la matriz \$global_facts con la excepción que también se especifica el ID GEDCOM de la persona a la cual se le quieren ocultar los acontecimientos. De esta forma, se puede ocultar un matrimonio para una persona en particular.<br><br>Modifica las variables \$person_facts en el archivo de privacidad seleccionado.";
$pgv_lang["select_privacyfile_button"]	= "Seleccione el archivo de privacidad";
$pgv_lang["edit_langdiff"] = "Editar y configurar los archivos de idiomas";
$pgv_lang["edit_lang_utility"] = "Utilitario de edición de archivos de idioma";
$pgv_lang["edit_lang_utility_help"] = "Puede utilizar este utilitario para editar el contenido de un archivo de idioma utilizando como base el inglés.<br>Listará el contenido del archivo de idioma original en inglés y el contenido en el idioma elegido.<br>Después de presionar en el mensaje del idioma elegido se abrirá una ventana donde podrá modificar y guardar el mensaje en el idioma elegido.";
$pgv_lang["edit_lang_utility_warning"]	= "ATENCIÓN!<br /><br />Si decide utilizar el botón >#close_window_without_refresh#< debe tener en cuenta que no verá directamente los cambios en la pantalla del editor de idiomas hasta que no recargue manualmente la página y puede ocurrir que su archivo de idioma sea destruido si agrega un mensaje aún inexistente dentro del archivo de idioma o si edita nuevamente un mensaje que haya sido editado con anterioridad.<br /><br />Entonces, si realmente no sabe lo que está haciendo, por favor no utilice el botón <br />>#close_window_without_refresh#<.";
$pgv_lang["language_to_edit"] = "Idioma a editar";
$pgv_lang["file_to_edit"] = "Tipo de archivo del idioma a editar";
$pgv_lang["lang_save"] = "Guardar";
$pgv_lang["contents"] = "Contenido";
$pgv_lang["listing"] = "Listado";
$pgv_lang["no_content"] = "Sin contenido";
$pgv_lang["editlang_help"] = "Editar mensaje del archivo de idioma";
$pgv_lang["cancel"] = "Cancelar";
$pgv_lang["savelang_help"] = "Guardar mensaje editado";
$pgv_lang["original_message"] = "Mensaje original";
$pgv_lang["message_to_edit"] = "Mensaje a editar";
$pgv_lang["changed_message"] = "Contenido modificado";
$pgv_lang["message_empty_warning"] = "-> Atención! Mensaje vacío en [#LANGUAGE_FILE#] <-";
$pgv_lang["language_to_export"] = "Idioma a exportar";
$pgv_lang["export_lang_utility"] = "Utilitario de exportación de idiomas";
$pgv_lang["export"] = "Exportar";
$pgv_lang["export_lang_utility_help"] = "En este módulo puede elegir un idioma y presionar el botón \"exportar\" para exportar los mensajes de ayuda del archivo ayuda_de_configuración del idioma elegido para crear un documento.";
$pgv_lang["export_ok"] = "Los mensajes de ayuda fueron exportados";
$pgv_lang["compare_lang_utility"] = "Utilitario de comparación de idiomas";
$pgv_lang["compare_lang_utility_help"] = "Este módulo comparará dos archivos de idioma y proporcionará una lista de los agregados y quitas entre ellos.<br>Vea el archivo [<a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a>] para consultar todos los cambios de idiomas.";
$pgv_lang["new_language"] = "Idioma fuente";
$pgv_lang["old_language"] = "Idioma destino";
$pgv_lang["compare"] = "Comparar";
$pgv_lang["comparing"] = "Archivos de idioma comparados";
$pgv_lang["additions"] = "Agregados";
$pgv_lang["no_additions"] = "Sin agregados";
$pgv_lang["subtractions"] = "Quitas";
$pgv_lang["no_subtractions"] = "Sin quitas";
$pgv_lang["config_lang_utility"] = "Configuración de idiomas soportados";
$pgv_lang["config_lang_utility_help"] = "Este módulo le ayudará a editar las opciones específicas de idioma para su uso en PhpGedView<br>Note que si ha realizado un cambio en las características originales de PhpGedView se crea un nuevo archivo (#INDEX_DIRECTORY#lang_settings.php) dentro del directorio #INDEX_DIRECTORY#.<br>Todos los cambios posteriores se realizarán sobre este archivo y PhpGedView usará sólo ESTE archivo.<br />Si tiene problemas con las opciones de idiomas informe que tiene este nuevo archivo dentro de su #INDEX_DIRECTORY#!";
$pgv_lang["active"] = "Activo";
$pgv_lang["active_help"] = "Permite a los usuarios seleccionar este idioma si está habilitado el cambio de idioma";
$pgv_lang["edit_settings"] = "Editar ajustes";
$pgv_lang["lang_edit"] = "Editar";
$pgv_lang["lang_language"] = "Idioma";
$pgv_lang["export_filename"] = "Nombre del archivo que incluye la información exportada:";
$pgv_lang["lang_back"] = "Regresar al menú principal para editar y configurar los archivos de idioma";
$pgv_lang["lang_back_admin"] = "Regresar al Menú de Administración";
$pgv_lang["lang_back_manage_gedcoms"]	= "Regresar al menú de Administración del GEDCOM";
$pgv_lang["lang_name_czech"]	= "Checoslovaco";
$pgv_lang["lang_name_danish"] = "Danés";
$pgv_lang["lang_name_german"] = "Alemán";
$pgv_lang["lang_name_english"] = "Inglés";
$pgv_lang["lang_name_finnish"]	= "Finlandés";
$pgv_lang["lang_name_spanish"] = "Español";
$pgv_lang["lang_name_spanish-ar"] = "Español Latinoamericano";
$pgv_lang["lang_name_french"] = "Francés";
$pgv_lang["lang_name_italian"] = "Italiano";
$pgv_lang["lang_name_dutch"] = "Holandés";
$pgv_lang["lang_name_norwegian"] = "Noruego";
$pgv_lang["lang_name_polish"] = "Polaco";
$pgv_lang["lang_name_portuguese"]	= "Portugués";
$pgv_lang["lang_name_portuguese-br"]	= "Portugués Brasileño";
$pgv_lang["lang_name_swedish"] = "Sueco";
$pgv_lang["lang_name_turkish"] = "Turco";
$pgv_lang["lang_new_language"]	= "Nuevo Idioma";
$pgv_lang["lang_name_chinese"] = "Chino";
$pgv_lang["lang_name_hebrew"] = "Hebreo";
$pgv_lang["lang_name_hungarian"]	= "Húngaro";
$pgv_lang["lang_name_russian"] = "Ruso";
$pgv_lang["original_lang_name"] = "Nombre original en #D_LANGNAME#";
$pgv_lang["original_lang_name_help"] = "Cual es el nombre de este idioma en el propio idioma.<br /><br />Inglés se denomina English.<br />Alemán se denomina Deutsche.<br />Holandés se denomina Nederlands.<br />etc.";
$pgv_lang["lang_shortcut"] = "Abreviatura para archivos de idioma";
$pgv_lang["lang_shortcut_help"] = "Este código define la abreviatura utilizada para identificar el idioma elegido dentro de PhpGedView.<br />Normalmente es el primer código de \"Códigos de detección de idiomas\" que puede ser definido en el siguiente campo de la ventana de opciones de idioma.";
$pgv_lang["lang_langcode"]	= "Códigos de detección de Idioma";
$pgv_lang["lang_langcode_help"]	= "Estos códigos permiten a PhpGedView detectar la opción de idioma del navegador que el usuario actual está utilizando para ver sus páginas PhpGedView. Deben separarse por punto y coma ';'";
$pgv_lang["lang_filename"] = "Archivo de idioma";
$pgv_lang["lang_filename_help"] = "Nombre y ruta del archivo de idioma standard para traducciones.";
$pgv_lang["config_filename"] = "Nombre del archivo de ayuda de configuración";
$pgv_lang["config_filename_help"] = "Nombre y ruta del archivo de configuración de idioma para traducciones";
$pgv_lang["facts_filename"] = "Archivo de acontecimientos";
$pgv_lang["facts_filename_help"] = "Nombre y ruta del archivo con las traducciones de los acontecimientos GEDCOM.";
$pgv_lang["help_filename"] = "Archivo de ayuda";
$pgv_lang["help_filename_help"] = "Nombre y ruta del archivo con las traducciones del texto de ayuda";
$pgv_lang["flagsfile"] = "Nombre del archivo de nombre de banderas nacionales";
$pgv_lang["flagsfile_help"] = "Nombre y ruta del archivo de imagen de la bandera nacional del idioma elegido";
$pgv_lang["text_direction"] = "Sentido del texto";
$pgv_lang["text_direction_help"] = "Define el sentido en que se escribe el texto en el idioma elegido.<br /><br />Normalmente todos los lenguajes occidentales se escriben y se leen de izquierda a derecha.<br />Pero existen lenguajes como el Árabe o el Hebreo que usan el sentido opuesto.";
$pgv_lang["date_format"] = "Formato de la fecha";
$pgv_lang["date_format_help"] = "Este campo define el formato de fecha generalmente utilizado en trabajos de genealogía en el idioma seleccionado.<br />Las variables que pueden ser utilizadas son:<br />D para el día<br />M para el mes<br />Y para el año.<br /><br />Puede cambiar el orden de estas variables y también agregar caracteres delimitadores.<br /><br />La opción standard para esta variable es 'D M Y', que significa que una fecha de un registro GEDCOM tal como 'DATE 20 Nov 1965' se muestra dentro de PhpGedView como '20 Noviembre 1965'.<br /><br />Por ejemplo en Alemania este campo tiene el contenido: 'D. M Y' que significa que una fecha en idioma Alemán se mostrará como: '20. Noviembre 1965'.<br /><br />Otro ejemplo es el idioma Húngaro que define la fecha como 'Y. M D.' con lo que la fecha anterior será '1965. Noviembre 20.' dentro de PhpGedView. (si Noviembre fuera el nombre del mes 11 en Húngaro)<br />Otro ejemplo es el idioma Finlandés que define a la fecha como 'D.M#ta# Y'. Esta definición significa que en Finlandés, todos los meses que tienen un día en el registro GEDCOM, se mostrarán como 20.Noviembreta 1965 (si Noviembre fuera el nombre del mes 11 en Finlandés).";
$pgv_lang["time_format"]	= "Formato de la hora";
$pgv_lang["time_format_help"]	= "Este campo define el formato de hora utilizado en el idioma seleccionado.<br /><br />Las variables que pueden utilizarse son:<br />a - Antes del Meridiano o Después del Meridiano en minúscula - 'am' o 'pm'<br />A - Antes del Meridiano o Después del Meridiano en mayúscula; 'AM' o 'PM'<br />B - Muestra de la hora Internet 000 a 999<br />c - Fecha ISO 8601 (agregada en PHP 5_); 2004-02-12T15:19:21+00:00<br />d - Día del mes, 2 dígitos con ceros precedentes 01 a 31<br />D - Representación textual del día, tres letras; Lun a Dom<br />F - Representación textual completa del mes, tal como Enero o Marzo; Enero a Diciembre<br />g - Formato de 12 horas sin ceros precedentes; 1 a 12<br />G - Formato de 24 horas sin ceros precedentes; 0 a 23<br />h - Formato de 12 horas con ceros precedentes; 01 a 12<br />H - Formato de 24 horas con ceros precedentes; 00 a 23<br />i - Minutos con ceros precedentes; 00 a 59<br />I - ('i' mayúscula) Fecha conteniendo horario de verano: 1 con horario de verano, 0 sin horario de verano<br />j - Día del mes sin ceros precedentes; 1 a 31<br />l - ('L' minúscula) Representación textual completa del día de la semana; Domingo a Sábado<br />L - Año bisiesto; 1 si es bisiesto, 0 si no es bisiesto<br />m - Representación numérica del mes, con ceros precedentes; 01 a 12<br />M - Representación textual abreviada del mes, 3 letras; Ene a Dic<br />n - Representación numérica del mes, sin ceros precedentes; 1 a 12<br />O - Diferencia con la hora Greenwich (GMT) en horas; ej. +0200<br />r - Fecha con formato RFC 2822; ej. Mar, 21 Dic 2000 16:01:07 +0200<br />s - Segundos con ceros precedentes; 00 a 59<br />S - sufijo de números ordinales ingleses en el día del mes, 2 caracteres; st, nd, rd o th. Funciona bien con la opción 'j'<br />t - Número de días en el mes dado; 28 a 31<br />T - Huso horario de esta máquina; p.ej. CEST, EST, MDT...<br />U - Segundos desde la era UNIX (1 de Enero de 1970 00:00:00 GMT)<br />w - Representación numérica del día de la semana; 0 Domingo, 6 Sábado<br />W - Número ISO 8601 de la semana del año, comenzando las semanas en Lunes (agregado en PHP 4.1.0); ej. 42 (la semana 42 del año)<br />Y - Representación numérica completa del año, 4 caracteres; p.ej. 1999 ó 2003<br />y - Representación numérica de 2 dígitos del año; ej. 99 ó 03<br />z - Día del año (comenzando con 0); 0 a 365<br />Z - Compensación del huso horario en segundos. La compensación del huso horario hacia el Oeste de UTC es siempre negativa y hacia el Este es siempre positiva; -43200 a 43200<br /><br />Puede cambiar el orden de estas variables y también agregar caracteres delimitadores.<br />Por ejemplo en Alemania el contenido de este campo es: 'H:i:s' que genera '09:01:25'.<br />En Inglés la definición standard de este campo es 'g:i:sa' que genera '9:01:25am'.";
$pgv_lang["week_start"] = "Día de comienzo de la semana";
$pgv_lang["week_start_help"] = "El día de la semana en que ésta comienza en este idioma. Muchos idiomas comienzan la semana el Domingo, pero otros comienzan en Lunes u otros días.";
$pgv_lang["name_reverse"] = "Apellido primero";
$pgv_lang["name_reverse_help"] = "En algunos idiomas el apellido debe mostrarse primero en lugar de al final. Seleccionando esta opción, se mostrará el apellido primero.";
$pgv_lang["ltr"] = "Izquierda a derecha";
$pgv_lang["rtl"] = "Derecha a izquierda";
$pgv_lang["file_does_not_exist"] = "ERROR! Archivo inexistente...";
$pgv_lang["alphabet_upper"] = "Letras mayúsculas";
$pgv_lang["alphabet_upper_help"] = "Letras mayúsculas en este idioma. Este alfabeto se utiliza para realizar la clasificación de los nombres en mayúsculas en las listas de nombres de PhpGedView en el idioma seleccionado";
$pgv_lang["alphabet_lower"] = "Letras minúsculas";
$pgv_lang["alphabet_lower_help"] = "Letras minúsculas en este idioma. Este alfabeto se utiliza para realizar la clasificación de los nombres en minúsculas en las listas de nombres de PhpGedView en el idioma seleccionado";
$pgv_lang["lang_config_write_error"] = "Error al grabar la configuración de idioma en el archivo [language_settings.php]. Controle los permisos e intente nuevamente.";
$pgv_lang["lang_save_success"] = "Se grabaron con éxito los cambios de #PGV_LANG#";
$pgv_lang["translation_forum"]	= "Vínculo al foro de traducciones PhpGedView en SourceForge";
$pgv_lang["translation_forum_help"]	= "Este vínculo abre una nueva ventana en el navegador para conectarlo con el foro de traducciones de PhpGedView (http://sourceforge.net/forum/forum.php?forum_id=294245) donde puede conversar sobre problemas específicos de traducciones :-)";
$pgv_lang["system_time"]	= "Hora actual del sistema:";
$pgv_lang["gedcom_not_imported"]	= "Este GEDCOM aún no ha sido importado.";
$pgv_lang["lang_set_file_read_error"]	= "E R R O R!!! No pudo leerse [language_settings.php]!";
$pgv_lang["add_new_language"]	= "Agregar archivos y definiciones para un nuevo idioma";
$pgv_lang["add_new_language_help"]	= "Puede utilizar este utilitario para agregar un idioma todavía no soportado por PhpGedView.<br />Por favor complete todos los campos necesarios en la siguiente ventana.<br />Posteriormente a la creación de los nuevos archivos, podrá modificar los mensajes de ese idioma.";
$pgv_lang["add_new_lang_button"]	= "Agregar un nuevo idioma";
$pgv_lang["hide_translated"]	= "Ocultar traducidos";
$pgv_lang["lang_file_write_error"]	= "E R R O R !!!<br /><br />No se han podido grabar las modificaciones realizadas al archivo de idioma seleccionado!<br />Verifique los permisos de escritura en (#lang_filename#)|";
$pgv_lang["never"]					= "Nunca";
?>
